#ifndef WIZARDWRAPPER_H
#define WIZARDWRAPPER_H
#include "uosai_global.h"

#include <QVariant>
#include <QPropertyAnimation>

#include <DIconButton>
#include <DWidget>
#include <DMainWindow>
#include <DGuiApplicationHelper>
#include <DBlurEffectWidget>

DGUI_USE_NAMESPACE

namespace  uos_ai {

class CustomButton;
class WizardDPushButton;
class WizardWrapper : public DTK_WIDGET_NAMESPACE::DBlurEffectWidget
{
    Q_OBJECT
public:
    static WizardWrapper &instance();
    void initAnimation();
    void showWizardWrapperWithAnimation();
    void isShowHiddenAction(bool isShow);
    void setButtonHidden(bool isHidden);
    void updateCustomFunctions();
    bool isMouseInside() { return m_mouseInside; }
    bool isWidgetVisible() { return m_isVisible; }
    void setWidgetVisible(bool visible) {  m_isVisible = visible; }

protected:
    void paintEvent(QPaintEvent *event)override;
    bool eventFilter(QObject *watched, QEvent *event)override;
    void mousePressEvent(QMouseEvent *event) override;
    void mouseMoveEvent(QMouseEvent *event) override;
    void mouseReleaseEvent(QMouseEvent *event) override;
#ifdef COMPILE_ON_QT6
    void enterEvent(QEnterEvent *event) override;
#else
    void enterEvent(QEvent *event) override;
#endif
    void leaveEvent(QEvent *event) override;

signals:
    void signalFunctionTriggered(int wizardtype, QPoint cursorPos, bool isCustom);
    void signalRequestServer();
    void signalCloseBtnClicked();
    void signalIconBtnClicked();
    void signalEscEvent();
    void signalDisableInApp();

public slots:
    void showScribeWordsAtCursorPosition(QRect screenRect, QPoint& point, bool isMouseRelease, bool isShortcut);
    void onMoreMenuTriggered(const QAction *action);
    void onButtonClicked();
    void showMenu();
    void onCloseWidget();
    void onIconBtnClicked();

private:
    WizardWrapper(QWidget *parent = nullptr);
    void onUpdateSystemTheme(const DGuiApplicationHelper::ColorType &);
    void initUI();
    void initConnect();
    void adjustShowPos(const QRect &screenRect, QPoint &pos);
    bool isFirstClose();
    void expandWrapper();
    void createDynamicButtons();
    void updateButtonsFromCustomFunctions();
    uint calculateCustomFunctionListHash() const;
    void checkAndUpdateLayout();
    int calculateWidth();
    Q_DISABLE_COPY(WizardWrapper)

    DTK_WIDGET_NAMESPACE::DIconButton *m_iconBtn = nullptr;
    QList<WizardDPushButton *> m_functionButtons;
    WizardDPushButton *m_moreBtn = nullptr;
    WizardDPushButton *m_closeBtn = nullptr;

    DTK_WIDGET_NAMESPACE::DMenu *m_moreMenu = nullptr;
    DTK_WIDGET_NAMESPACE::DWidget *m_lineSep = nullptr;
    DTK_WIDGET_NAMESPACE::DWidget *m_lineSep1 = nullptr;
    DTK_WIDGET_NAMESPACE::DWidget *m_lineSep2 = nullptr;
    DTK_WIDGET_NAMESPACE::DWidget *m_lineSepSpace = nullptr;
    DTK_WIDGET_NAMESPACE::DMenu *m_disableMenu = nullptr;
    QAction *m_disableInAppAction = nullptr;
    QAction *m_disableGlobalAction = nullptr;
    QAction *m_disableMenuAction = nullptr;
    QAction *m_customSettings = nullptr;

    QList<QAction *> m_customActions;

    QPoint m_cursorPos;
    QRect m_screenRect;
    bool m_isExtend = false;
    QPropertyAnimation *m_animation = nullptr;
    bool m_mouseInside = false;
    bool m_isVisible = false;

    bool m_dragging = false;
    QPoint m_dragStartPos;

    uint m_customFunctionListHash = 0;
};
}
#endif // WIZARDWRAPPER_H
