// SPDX-FileCopyrightText: 2023 - 2025 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef TREEMODEL_H
#define TREEMODEL_H

#include "debug.h"
#include "variable.h"

#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>

class LocalTreeItem;
class LocalTreeModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    explicit LocalTreeModel(QObject *parent = nullptr);
    ~LocalTreeModel() override;

    void setHeaders(const QList<QString> &headers);
    QVariant data(const QModelIndex &index, int role) const override;
    Qt::ItemFlags flags(const QModelIndex &index) const override;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role = Qt::DisplayRole) const override;
    QModelIndex index(int row, int column,
                      const QModelIndex &parent = QModelIndex()) const override;
    QModelIndex parent(const QModelIndex &index) const override;
    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    int columnCount(const QModelIndex &parent = QModelIndex()) const override;
    bool hasChildren(const QModelIndex &parent) const override;

    // Custumize functions.
    void setDatas(IVariables &datas);
    void appendItem(LocalTreeItem* parent, const IVariables &vars);
    void clear();
    void clearHighlightItems();

    QModelIndex indexForItem(const LocalTreeItem *needle) const;

signals:
    void updateChildVariables(const QModelIndex &index);

private:
    LocalTreeItem *rootItem = nullptr;
    QList<LocalTreeItem *> items;
    QStringList headers;
};

#endif // TREEMODEL_H
