/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class CustomImportOrderCheck
extends AbstractCheck {
    public static final String MSG_LINE_SEPARATOR = "custom.import.order.line.separator";
    public static final String MSG_SEPARATED_IN_GROUP = "custom.import.order.separated.internally";
    public static final String MSG_LEX = "custom.import.order.lex";
    public static final String MSG_NONGROUP_IMPORT = "custom.import.order.nonGroup.import";
    public static final String MSG_NONGROUP_EXPECTED = "custom.import.order.nonGroup.expected";
    public static final String MSG_ORDER = "custom.import.order";
    public static final String STATIC_RULE_GROUP = "STATIC";
    public static final String SAME_PACKAGE_RULE_GROUP = "SAME_PACKAGE";
    public static final String THIRD_PARTY_PACKAGE_RULE_GROUP = "THIRD_PARTY_PACKAGE";
    public static final String STANDARD_JAVA_PACKAGE_RULE_GROUP = "STANDARD_JAVA_PACKAGE";
    public static final String SPECIAL_IMPORTS_RULE_GROUP = "SPECIAL_IMPORTS";
    private static final String NON_GROUP_RULE_GROUP = "NOT_ASSIGNED_TO_ANY_GROUP";
    private static final Pattern GROUP_SEPARATOR_PATTERN = Pattern.compile("\\s*###\\s*");
    private final List<String> customOrderRules = new ArrayList<String>();
    private final List<ImportDetails> importToGroupList = new ArrayList<ImportDetails>();
    private String customImportOrderRules = "";
    private String samePackageDomainsRegExp = "";
    private Pattern standardPackageRegExp = Pattern.compile("^(java|javax)\\.");
    private Pattern thirdPartyPackageRegExp = Pattern.compile(".*");
    private Pattern specialImportsRegExp = Pattern.compile("^$");
    private boolean separateLineBetweenGroups = true;
    private boolean sortImportsInGroupAlphabetically;
    private int samePackageMatchingDepth = 2;

    public final void setStandardPackageRegExp(Pattern regexp) {
        this.standardPackageRegExp = regexp;
    }

    public final void setThirdPartyPackageRegExp(Pattern regexp) {
        this.thirdPartyPackageRegExp = regexp;
    }

    public final void setSpecialImportsRegExp(Pattern regexp) {
        this.specialImportsRegExp = regexp;
    }

    public final void setSeparateLineBetweenGroups(boolean value) {
        this.separateLineBetweenGroups = value;
    }

    public final void setSortImportsInGroupAlphabetically(boolean value) {
        this.sortImportsInGroupAlphabetically = value;
    }

    public final void setCustomImportOrderRules(String inputCustomImportOrder) {
        if (!this.customImportOrderRules.equals(inputCustomImportOrder)) {
            for (String currentState : GROUP_SEPARATOR_PATTERN.split(inputCustomImportOrder)) {
                this.addRulesToList(currentState);
            }
            this.customOrderRules.add(NON_GROUP_RULE_GROUP);
        }
        this.customImportOrderRules = inputCustomImportOrder;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.importToGroupList.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.samePackageDomainsRegExp = CustomImportOrderCheck.createSamePackageRegexp(this.samePackageMatchingDepth, ast);
        } else {
            String importFullPath = CustomImportOrderCheck.getFullImportIdent(ast);
            boolean isStatic = ast.getType() == 152;
            this.importToGroupList.add(new ImportDetails(importFullPath, this.getImportGroup(isStatic, importFullPath), isStatic, ast));
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (!this.importToGroupList.isEmpty()) {
            this.finishImportList();
        }
    }

    private void finishImportList() {
        String currentGroup = this.getFirstGroup();
        int currentGroupNumber = this.customOrderRules.lastIndexOf(currentGroup);
        ImportDetails previousImportObjectFromCurrentGroup = null;
        String previousImportFromCurrentGroup = null;
        for (ImportDetails importObject : this.importToGroupList) {
            String importGroup = importObject.getImportGroup();
            String fullImportIdent = importObject.getImportFullPath();
            if (importGroup.equals(currentGroup)) {
                this.validateExtraEmptyLine(previousImportObjectFromCurrentGroup, importObject, fullImportIdent);
                if (this.isAlphabeticalOrderBroken(previousImportFromCurrentGroup, fullImportIdent)) {
                    this.log(importObject.getImportAST(), MSG_LEX, fullImportIdent, previousImportFromCurrentGroup);
                } else {
                    previousImportFromCurrentGroup = fullImportIdent;
                }
                previousImportObjectFromCurrentGroup = importObject;
                continue;
            }
            if (this.customOrderRules.size() > currentGroupNumber + 1) {
                String nextGroup = this.getNextImportGroup(currentGroupNumber + 1);
                if (importGroup.equals(nextGroup)) {
                    this.validateMissedEmptyLine(previousImportObjectFromCurrentGroup, importObject, fullImportIdent);
                    currentGroup = nextGroup;
                    currentGroupNumber = this.customOrderRules.lastIndexOf(nextGroup);
                    previousImportFromCurrentGroup = fullImportIdent;
                } else {
                    this.logWrongImportGroupOrder(importObject.getImportAST(), importGroup, nextGroup, fullImportIdent);
                }
                previousImportObjectFromCurrentGroup = importObject;
                continue;
            }
            this.logWrongImportGroupOrder(importObject.getImportAST(), importGroup, currentGroup, fullImportIdent);
        }
    }

    private void validateMissedEmptyLine(ImportDetails previousImport, ImportDetails importObject, String fullImportIdent) {
        if (this.isEmptyLineMissed(previousImport, importObject)) {
            this.log(importObject.getImportAST(), MSG_LINE_SEPARATOR, fullImportIdent);
        }
    }

    private void validateExtraEmptyLine(ImportDetails previousImport, ImportDetails importObject, String fullImportIdent) {
        if (this.isSeparatedByExtraEmptyLine(previousImport, importObject)) {
            this.log(importObject.getImportAST(), MSG_SEPARATED_IN_GROUP, fullImportIdent);
        }
    }

    private String getFirstGroup() {
        ImportDetails firstImport = this.importToGroupList.get(0);
        return this.getImportGroup(firstImport.isStaticImport(), firstImport.getImportFullPath());
    }

    private boolean isAlphabeticalOrderBroken(String previousImport, String currentImport) {
        return this.sortImportsInGroupAlphabetically && previousImport != null && CustomImportOrderCheck.compareImports(currentImport, previousImport) < 0;
    }

    private boolean isEmptyLineMissed(ImportDetails previousImportObject, ImportDetails currentImportObject) {
        return this.separateLineBetweenGroups && this.getCountOfEmptyLinesBetween(previousImportObject.getEndLineNumber(), currentImportObject.getStartLineNumber()) != 1;
    }

    private boolean isSeparatedByExtraEmptyLine(ImportDetails previousImportObject, ImportDetails currentImportObject) {
        return previousImportObject != null && this.getCountOfEmptyLinesBetween(previousImportObject.getEndLineNumber(), currentImportObject.getStartLineNumber()) > 0;
    }

    private void logWrongImportGroupOrder(DetailAST importAST, String importGroup, String currentGroupNumber, String fullImportIdent) {
        if (NON_GROUP_RULE_GROUP.equals(importGroup)) {
            this.log(importAST, MSG_NONGROUP_IMPORT, fullImportIdent);
        } else if (NON_GROUP_RULE_GROUP.equals(currentGroupNumber)) {
            this.log(importAST, MSG_NONGROUP_EXPECTED, importGroup, fullImportIdent);
        } else {
            this.log(importAST, MSG_ORDER, importGroup, currentGroupNumber, fullImportIdent);
        }
    }

    private String getNextImportGroup(int currentGroupNumber) {
        int nextGroupNumber = currentGroupNumber;
        while (this.customOrderRules.size() > nextGroupNumber + 1 && !this.hasAnyImportInCurrentGroup(this.customOrderRules.get(nextGroupNumber))) {
            ++nextGroupNumber;
        }
        return this.customOrderRules.get(nextGroupNumber);
    }

    private boolean hasAnyImportInCurrentGroup(String currentGroup) {
        boolean result = false;
        for (ImportDetails currentImport : this.importToGroupList) {
            if (!currentGroup.equals(currentImport.getImportGroup())) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getImportGroup(boolean isStatic, String importPath) {
        String importPathTrimmedToSamePackageDepth;
        RuleMatchForImport bestMatch = new RuleMatchForImport(NON_GROUP_RULE_GROUP, 0, 0);
        if (isStatic && this.customOrderRules.contains(STATIC_RULE_GROUP)) {
            bestMatch.group = STATIC_RULE_GROUP;
            bestMatch.matchLength = importPath.length();
        } else if (this.customOrderRules.contains(SAME_PACKAGE_RULE_GROUP) && this.samePackageDomainsRegExp.equals(importPathTrimmedToSamePackageDepth = CustomImportOrderCheck.getFirstDomainsFromIdent(this.samePackageMatchingDepth, importPath))) {
            bestMatch.group = SAME_PACKAGE_RULE_GROUP;
            bestMatch.matchLength = importPath.length();
        }
        for (String group : this.customOrderRules) {
            if (STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(group)) {
                bestMatch = CustomImportOrderCheck.findBetterPatternMatch(importPath, STANDARD_JAVA_PACKAGE_RULE_GROUP, this.standardPackageRegExp, bestMatch);
            }
            if (!SPECIAL_IMPORTS_RULE_GROUP.equals(group)) continue;
            bestMatch = CustomImportOrderCheck.findBetterPatternMatch(importPath, group, this.specialImportsRegExp, bestMatch);
        }
        if (NON_GROUP_RULE_GROUP.equals(bestMatch.group) && this.customOrderRules.contains(THIRD_PARTY_PACKAGE_RULE_GROUP) && this.thirdPartyPackageRegExp.matcher(importPath).find()) {
            bestMatch.group = THIRD_PARTY_PACKAGE_RULE_GROUP;
        }
        return bestMatch.group;
    }

    private static RuleMatchForImport findBetterPatternMatch(String importPath, String group, Pattern regExp, RuleMatchForImport currentBestMatch) {
        RuleMatchForImport betterMatchCandidate = currentBestMatch;
        Matcher matcher = regExp.matcher(importPath);
        while (matcher.find()) {
            int matchStart = matcher.start();
            int length = matcher.end() - matchStart;
            if (length <= betterMatchCandidate.matchLength && (length != betterMatchCandidate.matchLength || matchStart >= betterMatchCandidate.matchPosition)) continue;
            betterMatchCandidate = new RuleMatchForImport(group, length, matchStart);
        }
        return betterMatchCandidate;
    }

    private static int compareImports(String import1, String import2) {
        String import2Token;
        String import1Token;
        int result = 0;
        String separator = "\\.";
        String[] import1Tokens = import1.split("\\.");
        String[] import2Tokens = import2.split("\\.");
        for (int i = 0; i != import1Tokens.length && i != import2Tokens.length && (result = (import1Token = import1Tokens[i]).compareTo(import2Token = import2Tokens[i])) == 0; ++i) {
        }
        if (result == 0) {
            result = Integer.compare(import1Tokens.length, import2Tokens.length);
        }
        return result;
    }

    private int getCountOfEmptyLinesBetween(int fromLineNo, int toLineNo) {
        int result = 0;
        String[] lines = this.getLines();
        for (int i = fromLineNo + 1; i <= toLineNo - 1; ++i) {
            if (!CommonUtil.isBlank(lines[i - 1])) continue;
            ++result;
        }
        return result;
    }

    private static String getFullImportIdent(DetailAST token) {
        String ident = "";
        if (token != null) {
            ident = FullIdent.createFullIdent(token.findFirstToken(59)).getText();
        }
        return ident;
    }

    private void addRulesToList(String ruleStr) {
        if (STATIC_RULE_GROUP.equals(ruleStr) || THIRD_PARTY_PACKAGE_RULE_GROUP.equals(ruleStr) || STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(ruleStr) || SPECIAL_IMPORTS_RULE_GROUP.equals(ruleStr)) {
            this.customOrderRules.add(ruleStr);
        } else if (ruleStr.startsWith(SAME_PACKAGE_RULE_GROUP)) {
            String rule = ruleStr.substring(ruleStr.indexOf(40) + 1, ruleStr.indexOf(41));
            this.samePackageMatchingDepth = Integer.parseInt(rule);
            if (this.samePackageMatchingDepth <= 0) {
                throw new IllegalArgumentException("SAME_PACKAGE rule parameter should be positive integer: " + ruleStr);
            }
            this.customOrderRules.add(SAME_PACKAGE_RULE_GROUP);
        } else {
            throw new IllegalStateException("Unexpected rule: " + ruleStr);
        }
    }

    private static String createSamePackageRegexp(int firstPackageDomainsCount, DetailAST packageNode) {
        String packageFullPath = CustomImportOrderCheck.getFullImportIdent(packageNode);
        return CustomImportOrderCheck.getFirstDomainsFromIdent(firstPackageDomainsCount, packageFullPath);
    }

    private static String getFirstDomainsFromIdent(int firstPackageDomainsCount, String packageFullPath) {
        StringBuilder builder = new StringBuilder(256);
        StringTokenizer tokens = new StringTokenizer(packageFullPath, ".");
        for (int count = firstPackageDomainsCount; count > 0 && tokens.hasMoreTokens(); --count) {
            builder.append(tokens.nextToken()).append('.');
        }
        return builder.toString();
    }

    private static class RuleMatchForImport {
        private final int matchPosition;
        private int matchLength;
        private String group;

        RuleMatchForImport(String group, int length, int position) {
            this.group = group;
            this.matchLength = length;
            this.matchPosition = position;
        }
    }

    private static class ImportDetails {
        private final String importFullPath;
        private final String importGroup;
        private final boolean staticImport;
        private final DetailAST importAST;

        ImportDetails(String importFullPath, String importGroup, boolean staticImport, DetailAST importAST) {
            this.importFullPath = importFullPath;
            this.importGroup = importGroup;
            this.staticImport = staticImport;
            this.importAST = importAST;
        }

        public String getImportFullPath() {
            return this.importFullPath;
        }

        public int getStartLineNumber() {
            return this.importAST.getLineNo();
        }

        public int getEndLineNumber() {
            return this.importAST.getLastChild().getLineNo();
        }

        public String getImportGroup() {
            return this.importGroup;
        }

        public boolean isStaticImport() {
            return this.staticImport;
        }

        public DetailAST getImportAST() {
            return this.importAST;
        }
    }
}

