// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
// 
// SPDX-License-Identifier: GPL-3.0-or-later
#pragma once

#include "dbusproxybase.hpp"
#include "system_org_deepin_dde_PasswdConf1.h"

class SystemPasswdConf1Proxy : public DBusProxyBase {
public:
    SystemPasswdConf1Proxy(QString dbusName, QString dbusPath, QString dbusInterface,
        QString proxyDbusName, QString proxyDbusPath, QString proxyDbusInterface,
        QDBusConnection::BusType dbusType, QObject *parent = nullptr) 
        : DBusProxyBase(dbusName, dbusPath, dbusInterface, proxyDbusName, proxyDbusPath, proxyDbusInterface, dbusType, parent)
    {
        InitFilterProperies(QStringList({}));
        InitFilterMethods(QStringList({"GetEnabled", "GetLengthLimit", "GetValidateRequired", "WriteConfig"}));
        QMap<QString, QString> auth;
        auth["Backup"] = "org.deepin.dde.api.proxy";
        auth["Reset"] = "org.deepin.dde.api.proxy";
        auth["SetEnabled"] = "org.deepin.dde.api.proxy";
        auth["SetFirstLetterUpper"] = "org.deepin.dde.api.proxy";
        auth["SetLengthLimit"] = "org.deepin.dde.api.proxy";
        auth["SetValidatePolicy"] = "org.deepin.dde.api.proxy";
        auth["SetValidateRequired"] = "org.deepin.dde.api.proxy";
        auth["WriteConfig"] = "org.deepin.dde.api.proxy";
        InitCheckAuthorization(auth);
        ServiceStart();
    }
    virtual DDBusExtendedAbstractInterface *initConnect()
    {
        m_dbusProxy = new org::deepin::dde::PasswdConf1(m_dbusName, m_dbusPath, QDBusConnection::systemBus(), this);
        return m_dbusProxy;
    }
private:
    org::deepin::dde::PasswdConf1 *m_dbusProxy;
};


