/*
 * @(#)Threed.h
 *
 * Copyright 1994 - 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Threed */

#ifndef _XtThreed_h
#define _XtThreed_h

/***********************************************************************
 *
 * 3D Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNselectColor ((char *) "selectColor")
#define XtNframeColor ((char *) "frameColor")
#define XtNanotherBrush ((char *) "anotherBrush")
#define XtNblackBrush ((char *) "blackBrush")
#define XtNdkgrayBrush ((char *) "dkgrayBrush")
#define XtNgrayBrush ((char *) "grayBrush")
#define XtNltgrayBrush ((char *) "ltgrayBrush")
#define XtNwhiteBrush ((char *) "whiteBrush")
#define XtNltltgrayBrush ((char *) "ltltgrayBrush")
#define XtNdkdkgrayBrush ((char *) "dkdkgrayBrush")
#define XtNstippleFrame ((char *) "stippleFrame")
#define XtNsurfaceBorder ((char *) "surfaceBorder")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNdistanceX ((char *) "distanceX")
#define XtNdistanceY ((char *) "distanceY")
#define XtNdistanceZ ((char *) "distanceZ")
#define XtNthetaDegrees ((char *) "thetaDegrees")
#define XtNphiDegrees ((char *) "phiDegrees")
#define XtNpsiDegrees ((char *) "psiDegrees")
#define XtNsurface ((char *) "surface")
#define XtNobject ((char *) "object")
#define XtNobjectName ((char *) "objectName")
#define XtNobjectNumber ((char *) "objectNumber")
#define XtNobjectList ((char *) "objectList")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNbuffer ((char *) "buffer")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCSelectColor ((char *) "SelectColor")
#define XtCFrameColor ((char *) "FrameColor")
#define XtCStippleFrame ((char *) "StippleFrame")
#define XtCMono ((char *) "Mono")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCDistanceX ((char *) "DistanceX")
#define XtCDistanceY ((char *) "DistanceY")
#define XtCDistanceZ ((char *) "DistanceZ")
#define XtCThetaDegrees ((char *) "ThetaDegrees")
#define XtCPhiDegrees ((char *) "PhiDegrees")
#define XtCPsiDegrees ((char *) "PsiDegrees")
#define XtCSurface ((char *) "Surface")
#define XtCObject ((char *) "Object")
#define XtCObjectName ((char *) "ObjectName")
#define XtCObjectNumber ((char *) "ObjectNumber")
#define XtCObjectList ((char *) "ObjectList")
#define XtCMenu ((char *) "Menu")
#define XtCBuffer ((char *) "Buffer")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _ThreeDClassRec *ThreeDWidgetClass;

extern WidgetClass threedWidgetClass;

typedef struct {
  int reason;
  XEvent *event;
  char message[81];
} threedCallbackStruct;
#endif

#define ACTION_LOAD 100
#define ACTION_EXIT 101
#define ACTION_HIDE 102
#define ACTION_SET 103
#define ACTION_SURFACE 104
#define ACTION_OBJECT 105
#define ACTION_SPEED 202
#define ACTION_SLOW 203
#define ACTION_SOUND 204
#define ACTION_TETRA 300
#define ACTION_HEXA 301
#define ACTION_OCTA 302
#define ACTION_DODECA 303
#define ACTION_ICOSA 304
#define ACTION_RHOMBIC 305
#define ACTION_TRIACONTA 306
#define ACTION_TRUNC 307
#define ACTION_IRREG 308
#define ACTION_TETRADECA 309
#define ACTION_STAR 310
#define ACTION_GREAT_DODECA 311
#define ACTION_SMALL_STEL_DODECA 312
#define ACTION_GREAT_STEL_DODECA 313
#define ACTION_GREAT_ICOSA 314
#define ACTION_CUBOCT 315
#define ACTION_SQUARE_ANTIPRISM 316
#define ACTION_PYRAMID 317
#define ACTION_CUBES 318
#define ACTION_F16 319
#define ACTION_DISTXI 400
#define ACTION_DISTXD 401
#define ACTION_DISTYI 402
#define ACTION_DISTYD 403
#define ACTION_DEPTHZI 404
#define ACTION_DEPTHZD 405
#define ACTION_THETAI 500
#define ACTION_THETAD 501
#define ACTION_PHII 502
#define ACTION_PHID 503
#define ACTION_PSII 504
#define ACTION_PSID 505
#define ACTION_DIAG0 506
#define ACTION_DIAG1 507
#define ACTION_DIAG2 508
#define ACTION_DIAG3 509
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define NUM_DEGREES 360
#define ST_ANGLE 180
#define RT_ANGLE 90

#define MIN_DISTANCE (-100)
#define MAX_DISTANCE 100
#define MIN_DEPTH (-50)
#define MAX_DEPTH 150
#define MIN_DEGREES 0
#define MAX_DEGREES (NUM_DEGREES-1)

#define DEFAULT_SURFACE TRUE
#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE

typedef struct _ThreeDRec *ThreeDWidget;

typedef struct _IntPoint3D {
	int x, y, z;
} IntPoint3D;

typedef struct _IntAngle3D {
	int theta; /* relative to y axis */
	int phi; /* relative to x axis */
	int psi; /* relative to z axis */
} IntAngle3D;

extern void intCat(char ** string, const char * var1, const int var2);
#if 0
extern void stringCat(char ** string, const char * var1, const char * var2);
#endif

#endif /* _XtThreed_h */
/* DON'T ADD STUFF AFTER THIS #endif */
