/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#include <xorg/xf86.h>
#include <xorg/xf86Module.h>
#include "extension.h"
#include "uace.h"

static void uaceModuleInit(INITARGS);

static MODULESETUPPROTO(uaceSetup);

ExtensionModule uaceExt =
{
    uaceModuleInit,
    "UACE",
#if XORG < 112
    NULL,
    NULL,
#endif
    NULL
};

static XF86ModuleVersionInfo uaceVersRec =
{
    "uace",
    "uniontech Access Control Extension",
    MODINFOSTRING1,
    MODINFOSTRING2,
    XORG_VERSION_CURRENT,
    1, 0, 0,
    ABI_CLASS_EXTENSION,         /* needs the server extension ABI */
    ABI_EXTENSION_VERSION,
    MOD_CLASS_EXTENSION,
    {0,0,0,0}
};

_X_EXPORT XF86ModuleData uaceModuleData = { &uaceVersRec, uaceSetup, NULL };

static void *
uaceSetup(void * module, void * opts, int *errmaj, int *errmin) {
    LoadExtensionList(&uaceExt, 1, FALSE);
    /* Need a non-NULL return value to indicate success */
    return (void *)1;
}

static void uaceModuleInit(INITARGS)
{
    uaceExtensionInit();
}