/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _UACEEXT_H_
#define _UACEEXT_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xmd.h>

#define UACE_EXTENSION_NAME "UACE-EXTENSION"

#define X_UaceExtSetProtectedWindow 0
#define X_UaceExtRemoveProtectedWindow 1
#define X_UaceExtGetWindowPID 2
#define X_UaceExtSetScreenShotTools 3
#define X_UaceExtRemoveScreenShotTools 4
#define X_UaceExtFreeScreenShotTools 5
#define X_UaceExtRegisterSelectionSpy 6

#define sz_xUaceExtSetProtectedWindowReq 12
#define sz_xUaceExtSetProtectedWindowReply 32

#define sz_xUaceExtRemoveProtectedWindowReq 12
#define sz_xUaceExtRemoveProtectedWindowReply 32

#define sz_xUaceExtGetWindowPIDReq 12
#define sz_xUaceExtGetWindowPIDReply 32

#define sz_xUaceExtSetScreenShotToolsReq 16
#define sz_xUaceExtSetScreenShotToolsReply 32

#define sz_xUaceExtRemoveScreenShotToolsReq 16
#define sz_xUaceExtRemoveScreenShotToolsReply 32

#define sz_xUaceExtFreeScreenShotToolsReq 12
#define sz_xUaceExtFreeScreenShotToolsReply 32

#define sz_xUaceExtRegisterSelectionSpyReq 12
#define sz_xUaceExtRegisterSelectionSpyReply 32

Bool XUaceExtQueryExtension(Display* dpy, int* event_basep, int* error_basep);
Bool XUaceExtSetProtectedWindow(Display* dpy, Window window);
Bool XUaceExtRemoveProtectedWindow(Display* dpy, Window window);
int  XUaceExtGetWindowPID(Display* dpy, Window window);
Bool XUaceExtSetScreenShotTools(Display* dpy, const char *name);
Bool XUaceExtRemoveScreenShotTools(Display* dpy, char *name);
Bool XUaceExtFreeScreenShotTools(Display* dpy);

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
  Window window;
} xUaceExtSetProtectedWindowReq;

typedef struct {
 BYTE type;
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 pad0 B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xUaceExtSetProtectedWindowReply;

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
  Window window;
} xUaceExtRemoveProtectedWindowReq;

typedef struct {
 BYTE type;
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 pad0 B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xUaceExtRemoveProtectedWindowReply;

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
  Window window;
} xUaceExtGetWindowPIDReq;

typedef struct {
 BYTE type;
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 PID B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xUaceExtGetWindowPIDReply;

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
  const char *name;
} xUaceExtSetScreenShotToolsReq;

typedef struct {
 BYTE type;
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 pad0 B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xUaceExtSetScreenShotToolsReply;

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
  char *name;
} xUaceExtRemoveScreenShotToolsReq;

typedef struct {
 BYTE type;
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 pad0 B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xUaceExtRemoveScreenShotToolsReply;

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD8 paramLen;
  CARD8 pad0;
  CARD16 pad1 B16;
  Window window;
} xUaceExtFreeScreenShotToolsReq;

typedef struct {
 BYTE type;
 BYTE success;
 CARD16 sequenceNumber B16;
 CARD32 length B32;
 CARD32 PID B32;
 CARD32 pad1 B32;
 CARD32 pad2 B32;
 CARD32 pad3 B32;
 CARD32 pad4 B32;
 CARD32 pad5 B32;
} xUaceExtFreeScreenShotToolsReply;

typedef struct {
  CARD8 reqType;
  CARD8 uaceReqType;
  CARD16 length B16;
  CARD32 readfd B32;
  CARD32 writefd B32;
} xUaceExtRegisterSelectionSpyReq;

typedef struct {
  BYTE type;
  BYTE success;
  CARD16 sequenceNumber B16;
  CARD32 length B32;
  CARD32 pad1 B32;
  CARD32 pad2 B32;
  CARD32 pad3 B32;
  CARD32 pad4 B32;
  CARD32 pad5 B32;
  CARD32 pad6 B32;
} xUaceExtRegisterSelectionReply;

#ifdef __cplusplus
}
#endif

#endif