//
// Created by zxm on 2022/12/23.
//

#ifndef UOS_RECOVERY_BR_CONTEXT_H
#define UOS_RECOVERY_BR_CONTEXT_H

#include <QString>
#include <QMetaType>
#include <QDBusArgument>
#include "utils/Singleton.h"
#include "utils/global.h"
#include "URReadWriteLock.h"

struct Context {
    QString operateID;
    QString userName;
    int opType;

    Context();
    Context(const QString &opID, const QString &name, const int &type);
    Context& operator=(const Context &other);

    static void registerMetaType();
    friend QDBusArgument& operator<<(QDBusArgument &arg, const Context &ctx);
    friend const QDBusArgument& operator>>(const QDBusArgument &arg, Context &ctx);
};
Q_DECLARE_METATYPE(Context)

// Backup Recovery Context
class BRContext : public URS::Singleton<BRContext> {
public:
    bool isRunning();
    void setRun(bool run);
    void setContext(const Context &ctx);
    Context getContext();

protected:
    friend class URS::Singleton<BRContext>;
    BRContext();

private:
    bool m_isRun = false;
    Context m_context;
    URRWLock m_isRunSharedMutex;
    URRWLock m_contextSharedMutex;
};

#endif
